from __future__ import absolute_import, print_function, division

import argparse
import msgpack
import os
import re
import subprocess as subproc


GOSKY_PATH = '/Berkanavt/skynet/bin/gosky'
GOSKY_VERSION_RE = re.compile(r'gosky v(\d+)\.(\d+)(?:\.(\d+))?')


def getGoskyVersion():
    if not os.path.exists(GOSKY_PATH):
        return {'error': 'no gosky'}

    proc = subproc.Popen(
        [GOSKY_PATH, '-V'],
        stdout=subproc.PIPE,
        stderr=subproc.STDOUT
    )
    stdout = proc.stdout.read()
    proc.wait()
    if proc.returncode != 0:
        return {
            'error': 'failed',
            'output': stdout,
            'returncode': proc.returncode
        }

    match = GOSKY_VERSION_RE.match(stdout)
    if not match:
        return {
            'error': 'no version',
            'output': stdout,
            'returncode': 0
        }
    else:
        return {'version': [int(_ or 0) for _ in match.groups()]}


def main():
    parser = argparse.ArgumentParser()
    parser.add_argument('-f', '--format', choices=('pretty', 'msgpack'), default='pretty')
    args = parser.parse_args()

    v = getGoskyVersion()
    if args.format == 'pretty':
        from pprint import pprint as pp
        pp(v)
    elif args.format == 'msgpack':
        print(msgpack.dumps(v))
    else:
        raise Exception('Invalid format "%s"' % (args.format, ))
