from __future__ import absolute_import, print_function, division
import subprocess
import msgpack
import argparse

LLDP_COMMAND = "sudo -n lldpctl -f keyvalue"


def run_command(cmd):
    proc = subprocess.Popen(cmd.split(' '), stdout=subprocess.PIPE, stderr=subprocess.PIPE)
    stdout, stderr = proc.communicate()
    return stdout


def parse_lldpctl_output(output):
    result = {}
    # Parsing multiline values
    for line in output.splitlines():
        if '=' in line:
            key, value = line.split('=')
            result[key] = value
        else:
            # The key might be referenced before assignment
            # but it's ok for us - it means that output is corrupted
            result[key] += line
    if not result:
        raise Exception('Output of [' + LLDP_COMMAND + '] is empty')
    return result


def parse_args():
    parser = argparse.ArgumentParser()
    parser.add_argument('-f', '--format', choices=('pretty', 'msgpack'), default='pretty')
    return parser.parse_args()


def get_output():
    stdout = run_command(LLDP_COMMAND)
    result = parse_lldpctl_output(stdout)
    return result


def main():
    args = parse_args()
    result = get_output()
    if args.format == 'pretty':
        from pprint import pprint
        pprint(result)
    if args.format == 'msgpack':
        print(msgpack.packb(result))


if __name__ == '__main__':
    main()
