#!/skynet/python/bin/python

from __future__ import absolute_import, print_function

import re
import argparse
from pprint import pprint
import os

import py
import msgpack

def memleak():
    HOST_OS = os.uname()[0]

    if HOST_OS == "Linux":
        data = open("/proc/vmstat").read()

        inactive_anon = int(re.search("nr_inactive_anon (\d+)", data).group(1))
        active_anon = int(re.search("nr_active_anon (\d+)", data).group(1))
        anon = int(re.search("nr_anon_pages (\d+)", data).group(1))
        shmem = int(re.search("nr_shmem (\d+)", data).group(1))

        return float((inactive_anon + active_anon - anon - shmem) * os.sysconf('SC_PAGESIZE')) / 1024. / 1024. / 1024.
    else:
        return 0.

def parse_args():
    parser = argparse.ArgumentParser()
    parser.add_argument('-f', '--format', choices=('pretty', 'msgpack'), default='pretty')
    return parser.parse_args()


def main():
    args = parse_args()
    result = memleak()

    if args.format == 'pretty':
        pprint(result)
    if args.format == 'msgpack':
        print(msgpack.packb(result))


if __name__ == '__main__':
    main()
