#!/skynet/python/bin/python

from __future__ import absolute_import, print_function, division

import argparse
import msgpack
import random
import socket

import api.cqueue

from library.sky.hostresolver.resolver import Resolver
from library.config import query


def ping(implementation, hosts):
    r = dict.fromkeys(hosts)
    with api.cqueue.Client(implementation) as client:
        with client.ping(hosts) as session:
            for (host, res, err) in session.wait(60):
                r[host] = bool(res)
    return r


def random_hosts(hosts):
    try:
        if not hosts:
            # support old way of configuration
            conf = query('skynet.monitoring.cq')
            if conf['enabled']:
                hosts = conf['hosts']

        if not hosts:
            return [socket.getfqdn()]

        resolved = Resolver().resolveHosts(hosts)
        return list(resolved) if len(resolved) <= 5 else random.sample(resolved, 5)

    except BaseException:
        return [socket.getfqdn()]


def parse_args():
    parser = argparse.ArgumentParser()
    parser.add_argument('-f', '--format', choices=('pretty', 'msgpack'), default='pretty')
    parser.add_argument('-i', '--implementation', choices=('cqueue', 'cqudp'), default='cqueue')
    parser.add_argument('--hosts', default='')
    return parser.parse_args()


def main():
    args = parse_args()
    hosts = random_hosts(args.hosts)

    info = {'ping': ping(args.implementation, hosts)}

    if args.format == 'msgpack':
        print(msgpack.dumps(info))
    elif args.format == 'pretty':
        from pprint import pprint as pp
        pp(info)


if __name__ == '__main__':
    main()
