import argparse
import subprocess as subproc
import sys

import simplejson


def parse_args():
    parser = argparse.ArgumentParser()
    parser.add_argument('-f', '--format', choices=('pprint', 'msgpack'), default='pprint')
    parser.add_argument('--skyctl', default='/skynet/startup/skyctl')
    parser.add_argument('--namespace', default='infra')
    parser.add_argument('--service', default='oops-agent')

    args = parser.parse_args()
    return args


def get_skycore_stats(skyctl, ns, service):
    try:
        proc = subproc.Popen([skyctl, 'run-script', '-qq', ns, service, 'state'], stdout=subproc.PIPE)
    except:
        return []

    data = proc.stdout.read()
    proc.wait()

    if proc.returncode == 0:
        data = simplejson.loads(data)

        return data
    else:
        return {}


def main():
    args = parse_args()

    stats = get_skycore_stats(args.skyctl, args.namespace, args.service)

    if args.format == 'pprint':
        import pprint
        pprint.pprint(stats)
    else:
        import msgpack
        sys.stdout.write(msgpack.dumps(stats))


if __name__ == '__main__':
    main()
