from __future__ import absolute_import, print_function, division

import re
import argparse
import time
from pprint import pprint

import py
import msgpack


TAG_FILE = 'stamp.TAG'
CONF_FILE = 'shard.conf'
STATE_FILE = 'shard.state'
DB_BASE_PATH = py.path.local('/db/BASE')


def shard_state():
    shards = {}

    try:
        seen = set()
        for path in DB_BASE_PATH.listdir():
            try:
                rpath = path.realpath()
                if rpath in seen:
                    continue
                seen.add(rpath)
                name = rpath.basename

                shard = {}
                m = re.search(r'-(\d{10})$', name)
                if m:
                    shard['epoch'] = int(m.group(1))
                else:
                    m = re.search(r'-(\d{8})[_-](\d{6})$', name)
                    shard['epoch'] = int(time.mktime(time.strptime(m.group(1) + m.group(2), "%Y%m%d%H%M%S"))) if m else None

                reg = re.compile(r'^install\s*:\s*OK(\s|$)')
                statefile = rpath.join(STATE_FILE)
                if not filter(reg.match, statefile.readlines()):
                    continue

                reg = re.compile(r'^%mtime\s+(\d+)(\s|$)')
                conffile = rpath.join(CONF_FILE)
                mtime_line = filter(reg.match, conffile.readlines())
                m = reg.match(mtime_line[0])
                shard['mtime'] = int(m.group(1))

                reg = re.compile(r'^SearchZone\s*=\s*([^\s]+)(\s|$)')
                tagfile = rpath.join(TAG_FILE)
                if tagfile.check():
                    zone_line = filter(reg.match, tagfile.readlines())
                    m = reg.match(zone_line[0])
                    shard['zone'] = m.group(1)
                else:
                    shard['zone'] = 'unknown'

                shard['files'] = dict(
                    (p.relto(rpath), p.size()) for p in filter(lambda p: p.check(file=1), rpath.listdir())
                )

                shards[name] = shard
            except Exception:
                continue
    except Exception:
        pass

    return shards


def parse_args():
    parser = argparse.ArgumentParser()
    parser.add_argument('-f', '--format', choices=('pretty', 'msgpack'), default='pretty')
    return parser.parse_args()


def main():
    args = parse_args()
    result = shard_state()

    if args.format == 'pretty':
        pprint(result)
    if args.format == 'msgpack':
        print(msgpack.packb(result))


if __name__ == '__main__':
    main()
