#!/skynet/python/bin/python

from __future__ import absolute_import, print_function, division

import argparse
import subprocess
import pkg_resources
import socket
import time
import json

pkg_resources.require('msgpack-python')

import msgpack

FORMATS = ('msgpack', 'pp')


def yandex_dpkg():
    out, _ = subprocess.Popen(
        ["dpkg -l | grep yandex | awk '{print $2\"=\"$3}'"],
        stdout=subprocess.PIPE,
        stderr=subprocess.PIPE,
        shell=True
    ).communicate()

    res = {}
    for s in out.split('\n'):
        x = s.split('=')
        if len(x) == 2:
            res[x[0]] = x[1]

    return res


def lui():
    out, _ = subprocess.Popen(
        ["cat /etc/lui.conf | head -1"],
        stdout=subprocess.PIPE,
        stderr=subprocess.PIPE,
        shell=True
    ).communicate()

    return out


def tejblum():
    out, err = subprocess.Popen(
        ["cat /etc/passwd | grep -c tejblum"],
        stdout=subprocess.PIPE,
        stderr=subprocess.PIPE,
        shell=True
    ).communicate()

    if err:
        return 0
    return int(out)


def golovan(host='localhost', port=11003, tries=3, url='/version/'):
    for try_ in range(1, tries + 1):
        try:
            sock = socket.socket(socket.AF_INET, socket.SOCK_STREAM)
            sock.settimeout(5)
            sock.connect((host, int(port)))
            sock.send('GET %s HTTP/1.0\r\n' % (url, ))
            sock.send('Host: %s\r\n' % (host, ))
            sock.send('\r\n')
            buf = []
            while 1:
                data = sock.recv(8192)
                if not data:
                    break
                buf.append(data)
            data = ''.join(buf)
            return data.split('\r\n\r\n', 1)[1]
        except socket.error:
            time.sleep(0.1)
            if try_ == tries:
                return ''


def iss(host='localhost', port=25536, tries=3, url='/version'):
    for try_ in range(1, tries + 1):
        try:
            sock = socket.socket(socket.AF_INET, socket.SOCK_STREAM)
            sock.settimeout(5)
            sock.connect((host, int(port)))
            sock.send('GET %s HTTP/1.0\r\n' % (url, ))
            sock.send('Host: %s\r\n' % (host, ))
            sock.send('\r\n')
            buf = []
            while 1:
                data = sock.recv(8192)
                if not data:
                    break
                buf.append(data)
            data = ''.join(buf)
            data = data.split('\r\n\r\n', 1)[1]
            data = json.loads(data)
            return str(data['version'])
        except socket.error:
            time.sleep(0.1)
            if try_ == tries:
                return ''


def soft_info():
    return {
        'dpkg': yandex_dpkg(),
        'lui': lui(),
        'tejblum': tejblum(),
        'golovan': golovan(),
        'iss': iss(),
    }


def parse_args():
    parser = argparse.ArgumentParser()
    parser.add_argument('-f', '--format', choices=('pretty', 'msgpack'), default='pretty')
    return parser.parse_args()


def main():
    args = parse_args()
    result = soft_info()
    if args.format == 'pretty':
        import pprint
        pprint.pprint(result)
    if args.format == 'msgpack':
        print(msgpack.packb(result))


if __name__ == '__main__':
    main()
