import re

ISS_ILIST_URL = "http://127.0.0.1:25536/instances/active"
QLOUD_SUFFIX = '.qloud-d.yandex.net'

class EInstanceTypes(object):
        BSCONFIG = "bsconfig"
        GENCFG = "gencfg"
        QLOUD = "qloud"
        HOSTPORT = "hostport"
        FAKE = "fake"
        OPENSTACK = "openstack"
        YP = "yp"
        ALL = [BSCONFIG, GENCFG, QLOUD, HOSTPORT, FAKE, OPENSTACK, YP]


def _parse_version_tag(tag):
    stable_m = re.match('stable-(\d+)-r(\d+)', tag)
    if stable_m:
        major_tag = int(stable_m.group(1))
        minor_tag = int(stable_m.group(2))
        revision = None
    else:
        major_tag = 0
        minor_tag = 0
        trunk_m = re.match('trunk-(\d+)', tag)
        revision = int(trunk_m.group(1))

    return major_tag, minor_tag, revision


def _update_iss_instance_env(env):
    if env.get('properties', {}).get('DEPLOY_ENGINE', None) in ('YP_LITE',):
        # processing yp instances
        env['group'] = env['properties']['NANNY_SERVICE_ID']
        instance_type = EInstanceTypes.YP
    elif 'GENCFG_GROUP' in env['properties']:
        # processing gencfg instances
        env['group'] = env['properties']['GENCFG_GROUP']
        major_tag, minor_tag, revision = _parse_version_tag(env['properties']['GENCFG_RELEASE'])
        env['major_tag'] = major_tag
        env['minor_tag'] = minor_tag
        env['revision'] = revision
        instance_type = EInstanceTypes.GENCFG
    elif 'qloudDiscoveryComponent' in env['properties']:
        # processing qloud instances
        component = env['properties']['qloudDiscoveryComponent']
        if component.endswith(QLOUD_SUFFIX):
            component = component[:-len(QLOUD_SUFFIX)]
        service, environ, app, project, install_type = component.split('.')
        env['service'] = service
        env['environ'] = environ
        env['app'] = app
        env['project'] = project
        env['install_type'] = install_type
        instance_type = EInstanceTypes.QLOUD
    else:
        _update_iss_instance_env_from_tags(env)
        instance_type = EInstanceTypes.GENCFG

    return env, instance_type


def _update_iss_instance_env_from_tags(env):
    TKEY = "a_topology_version-"

    def get_version_from_tag(a_topology_version):
        return a_topology_version[len(TKEY):]

    tags = list(set(filter(lambda x: x.startswith(TKEY), env["properties"]["tags"].split(' '))))

    tag = None
    if len(tags) >= 2:
        trunk_key = 'a_topology_version-trunk'
        stable_key = 'a_topology_version-stable'

        stable_tags = filter(lambda x: x.startswith(stable_key), tags)
        trunk_tags = filter(lambda x: x.startswith(trunk_key), tags)

        if len(stable_tags) > 0:
            tag = max(map(get_version_from_tag, stable_tags))
        elif len(trunk_tags) > 0:
            tag = max(map(get_version_from_tag, trunk_tags))
    elif len(tags) == 1:
        tag = get_version_from_tag(tags[0])

    if tag is None:
        raise Exception("Can not detect tag: {}".format(tags))

    IKEY = "a_itype_"
    itypes = filter(lambda x: x.startswith(IKEY), env["properties"]["tags"].split(' '))
    if len(itypes) == 1:  # Skip old-style instances without autotags
        itype = itypes[0][len(IKEY):]
        if itype == "base":
            env["loadlog"] = "/usr/local/www/logs/current-loadlog-base-%s" % env["properties"]["port"]
        elif itype == "int":
            env["loadlog"] = "/usr/local/www/logs/current-loadlog-w-int-%s" % env["properties"]["port"]
        elif itype == "mmeta":
            env["loadlog"] = "/usr/local/www/logs/current-loadlog-base-%s" % env["properties"]["port"]
        elif itype == "fusion":
            env["loadlog"] = "/usr/local/www/logs/current-loadlog-fusion-%s" % env["properties"]["port"]

    major_tag, minor_tag, revision = _parse_version_tag(tag)
    env['major_tag'] = major_tag
    env['minor_tag'] = minor_tag
    env['revision'] = revision

    GKEY = "a_topology_group-"
    group = list(set(filter(lambda x: x.startswith(GKEY), env["properties"]["tags"].split(' '))))
    if len(group) == 1:
        group_name = group[0][len(GKEY):]
        env['group'] = group_name

    env["tags"] = env["properties"]["tags"].split(' ')

    return env


def instance_major_tag(instance_env):
    return instance_env["env"].get("major_tag", 0)


def instance_minor_tag(instance_env):
    return instance_env["env"].get("minor_tag", 0)


def instance_version(instance_env):
    rev = instance_env["env"].get("revision", 0)
    major_tag = instance_env["env"].get("major_tag", 0)
    minor_tag = instance_env["env"].get("minor_tag", 0)
    if rev:
        return 1000000000 + rev
    elif major_tag != 0 or minor_tag != 0:
        return 1000000 * major_tag + minor_tag
    else:
        return 0


def instance_group(instance_env):
    return instance_env["env"].get("group", "")
