import sys
from api.cqueue import Client
from library.sky.hostresolver import Resolver
from instanceusagev2_infreq import get_instances_with_usages


def main():
    count_err = 0
    count_ok = 0
    with Client(implementation='cqudp') as cqueue:
        hosts = Resolver().resolveHosts('I@ALL_SEARCH')
        with cqueue.run(
            hosts,
            get_instances_with_usages
        ) as session:
            for host, result, err in session.wait():
                if err:
                    print >>sys.stderr, 'Error on {}: {} `{}`'.format(host, err, err.message)
                    print >>sys.stderr, "".join(err._traceback)
                    count_err += 1
                    print >>sys.stderr, "OK/ERR", count_ok, count_err
                else:
                    # print '{0:<10} {1}'.format(host, result)
                    count_ok += 1
                    print >>sys.stderr, "OK/ERR", count_ok, count_err
                    for instance, instance_data in result.iteritems():
                        print "{}:{}".format(*instance), instance_data['group'], instance_data


if __name__ == "__main__":
    main()
