import os
import requests


def get_openstack_instances():
    res = []
    for pid in os.listdir('/proc'):
        if not pid.isdigit():
            continue
        try:
            with open('/proc/%s/cmdline' % pid, 'rb') as f:
                cmdline = f.read().split('\0')
        except IOError:
            # process died while iterating, nevermind that
            continue
        if not cmdline[0].startswith('qemu-system') or '-uuid' not in cmdline:
            # probably not openstack
            continue
        uuid_idx = cmdline.index('-uuid') + 1
        res.append((cmdline[uuid_idx], pid))
    return res


def get_tenant_id(uuid):
    tmp_dir = os.path.join(os.getenv('TMPDIR', '/tmp'), 'skynet_openstack_cache')
    cache_fname = os.path.join(tmp_dir, uuid)
    try:
        with open(cache_fname) as cache_file:
            tenant_id = cache_file.read().strip()
            assert(tenant_id)
    except Exception:
        url = 'https://os.cloud.yandex-team.ru/api/v1/instances/%s' % uuid
        r = requests.get(url, timeout=10)
        r.raise_for_status()
        tenant_id = r.json()['data'][0]['project_id']
        try:
            if not os.path.isdir(tmp_dir):
                os.makedirs(tmp_dir)
            with open(cache_fname, 'w') as cache_file:
                cache_file.write(tenant_id)
        except Exception:
            pass
    return tenant_id
