import os

try:
    from setuptools import setup
    from pkg_resources import require  # noqa
except ImportError:
    import sys
    print >> sys.stderr, 'Please install distribute from PyPi first.'
    exit(1)


NS_PKG_STUB = '__import__("pkg_resources").declare_namespace(__name__)'


from setuptools.command.bdist_egg import bdist_egg, walk_egg, log
from setuptools.command.test import test


class mbdist_egg(bdist_egg):  # noqa
    def make_init_files(self):
        """Create missing package __init__ files"""
        init_files = []
        for base, dirs, files in walk_egg(self.bdist_dir):
            if base == self.bdist_dir:
                # don't put an __init__ in the root
                continue

            if '__init__.py' not in files:
                pkg = base[len(self.bdist_dir) + 1:].replace(os.sep, '.')
                if self.distribution.has_contents_for(pkg):
                    log.warn("Creating missing __init__.py for %s", pkg)
                    filename = os.path.join(base, '__init__.py')
                    if not self.dry_run:
                        with open(filename, 'w') as f:
                            f.write(NS_PKG_STUB)
                    init_files.append(filename)

        return init_files


class PyTest(test):
    user_options = [
        ('keywords=', 'k', 'Pass keywords to pytest.'),
        ('exitfirst', 'x', 'Exit after first failure.'),
        ('showout', 's', 'Dont hide tests stdout/stderr.'),
        ('quiet', 'q', 'Be quiet.'),
    ]

    def initialize_options(self):
        self.keywords = None
        self.exitfirst = False
        self.showout = False

    def finalize_options(self):
        if self.exitfirst:
            self.exitfirst = True

    def run(self):
        self.run_tests()

    def run_tests(self):
        import pytest
        import sys

        if 'test' in sys.argv:
            args = sys.argv[sys.argv.index('test') + 1:]
        else:
            args = sys.argv[1:]

        raise SystemExit(pytest.main(args=args))


def plugin_script(name):
    return 'plugin__%s.py = ya.skynet.services.heartbeatserver.bulldozer.plugins.%s:main' % (
        name.replace('.', '_'),
        name
    )


setup(
    name='skynet-heartbeat-server-service',
    version='0.1',
    description='Skynet HeartBeat Server Service',
    zip_safe=True,
    install_requires=[
        'python-daemon',
        'PyYAML',
        'msgpack-python',
        'faulthandler',
        'pymongo',
        'Flask',
        'Flask-RESTful'
    ],
    packages=[
        'ya.skynet.services.heartbeatserver',
        'ya.skynet.services.heartbeatserver.bulldozer',
        'ya.skynet.services.heartbeatserver.bulldozer.plugins',
        'ya.skynet.services.heartbeatserver.bulldozer.plugins.monitoring',
        'ya.skynet.services.heartbeatserver.bulldozer.plugins.metrics',
        'ya.skynet.services.heartbeatserver.bulldozer.plugins.sre',
        'ya.skynet.services.heartbeatserver.daemon',
        'ya.skynet.services.heartbeatserver.rpc',
        'ya.skynet.services.heartbeatserver.utils',
    ],
    package_dir={'ya.skynet.services.heartbeatserver': 'src'},
    namespace_packages=['ya'],
    entry_points={
        'console_scripts': [
            'daemon = ya.skynet.services.heartbeatserver.daemon.daemon:main',
            'check = ya.skynet.services.heartbeatserver.daemon.check:main',
            plugin_script('null'),
            plugin_script('pinger'),
            plugin_script('pinger2'),
            plugin_script('skyinfo'),
            plugin_script('skystat'),
            plugin_script('oopsstat'),
            plugin_script('generic'),
            plugin_script('hostinfo'),
            plugin_script('softinfo'),
            plugin_script('shardsize'),
            plugin_script('shardstate'),
            plugin_script('searchcrash'),
            plugin_script('pluginerror'),
            plugin_script('instancestate'),
            plugin_script('instancestatev3'),
            plugin_script('instancestatev4'),
            plugin_script('monitoring.copier'),
            plugin_script('monitoring.cqueue'),
            plugin_script('metrics.copier'),
            plugin_script('metrics.copier_stat'),
            plugin_script('metrics.cqudp_api_calls'),
            plugin_script('metrics.portoshell_connections'),
            plugin_script('metrics.cqueue'),
            plugin_script('metrics.cqrestarts'),
            plugin_script('metrics.cqusage'),
            plugin_script('metrics.resolver'),
            plugin_script('instanceusage'),
            plugin_script('memleak'),
            plugin_script('lldpinfo'),
            plugin_script('sandbox_sync_stats'),
            plugin_script('sre.instanceusagev2'),
            plugin_script('sre.instanceusagev2_infreq'),
            plugin_script('sre.instanceusage_solomon'),
            plugin_script('who'),
            plugin_script('last'),
            plugin_script('dutop'),
        ]
    },
    cmdclass={'bdist_egg': mbdist_egg, 'test': PyTest}
)
