#!/skynet/python/bin/python
import datetime
import json
import pkg_resources

pkg_resources.require('pymongo')
pkg_resources.require('skynet-heartbeat-server-service')

REPORT_VERSION_1 = 1
VALID_REPORT_VERSIONS = (REPORT_VERSION_1, )

from ya.skynet.services.heartbeatserver.bulldozer import helper


def create_collection(db, name):
    c = db[name]
    c.ensure_index('host', unique=True)
    return c


def main():
    com = helper.Communicator().ready()
    dbc = helper.ReportCollection('dutop', onCreate=create_collection)
    for host, _, data in com.read():
        try:
            exists = dbc.coll.find_one({'host': host})
            if exists:
                report = exists
            else:
                report = {'host': host}

            report_version = data['report']['report_version']
            if report_version not in VALID_REPORT_VERSIONS:
                raise ValueError('report version: {} is not valid, available: {}'.format(
                    report_version, VALID_REPORT_VERSIONS))

            if report_version == REPORT_VERSION_1:
                report['du_top_data'] = json.dumps(data['report']['du_top'])
                report['cache_hours'] = data['report'].get('cache_hours', 0.0)

            report.update({
                'report_version': report_version,
                'received': datetime.datetime.now(),
                'generated': datetime.datetime.fromtimestamp(data['end'])
            })

            dbc.update(host, report)

        except (TypeError, KeyError, ValueError) as ex:
            com.discard(repr(ex))
        else:
            com.ready()
