#!/skynet/python/bin/python

"""
Generic plugin. It will store 'report' dict entry of the report given in the collection named as
the report name passed.
"""

import pkg_resources

pkg_resources.require('skynet-heartbeat-server-service')
from ya.skynet.services.heartbeatserver.bulldozer import helper


def main():
    dbcs = {}
    rdb = helper.ReportDatabase()
    # lacmus = helper.LacmusReporter()

    com = helper.Communicator().ready()
    for host, name, data in com.read():
        try:
            dbc = dbcs[name] if name in dbcs else dbcs.setdefault(name, helper.ReportCollection(name, rdb=rdb))
            dbc.update(host, helper.fixKeys(data['report']))
            # DON'T send reports to lacmus v2
            # if name == 'hostinfo':
            #     r = data['report']['os']
            #     for sig, value in [
            #         ('os.name', '{} {}'.format(r.get('name', 'unknown'), r.get('os_name', 'unknown'))),
            #         ('os.version', r.get('os_version', 'unknown')),
            #         ('kernel.version', r.get('version', 'unknown'))
            #     ]:
            #         lacmus.add_signal(sig, value)
            #
            #     lacmus.send_report(host, data['end'])
        except (TypeError, ValueError) as ex:
            com.discard(repr(ex))
        else:
            com.ready()
