#!/skynet/python/bin/python

import pkg_resources

pkg_resources.require('pymongo')
pkg_resources.require('msgpack-python')

import bson
import msgpack
import re

pkg_resources.require('skynet-heartbeat-server-service')
from ya.skynet.services.heartbeatserver.bulldozer import helper


def _group(tags):
    for tag in tags.split(' '):
        if tag.startswith('a_topology_group-'):
            return tag.partition('a_topology_group-')[2]
    return ''


def _version(tags):
    for tag in tags.split(' '):
        match = re.search(r'a_topology_version-stable-([0-9]*)-r([0-9]*)', tag)
        if match:
            return 1000000 * int(match.group(1)) + int(match.group(2))

        match = re.search(r'a_topology_version-trunk-([0-9]+)', tag)
        if match:
            return 1000000 * 1000 + int(match.group(1))

    return 0


def main():
    dbc = helper.ReportCollection('instancestatev3')
    com = helper.Communicator().ready()
    for host, _, data in com.read():
        try:
            report = data['report']

            for v in report['i'].itervalues():
                v.pop('m', None)
                if 'tags' in v:
                    v['tg'] = _group(v['tags'])
                    v['tv'] = _version(v['tags'])

            version = report.pop('v')
            dbc.update(
                host,
                {'state': bson.binary.Binary(msgpack.dumps(report)), 'version': version}
            )
        except (TypeError, KeyError, ValueError) as ex:
            com.discard(repr(ex))
        else:
            com.ready()
