#!/skynet/python/bin/python

import pkg_resources

pkg_resources.require('pymongo')
pkg_resources.require('msgpack-python')

import re
import pymongo

pkg_resources.require('skynet-heartbeat-server-service')
from ya.skynet.services.heartbeatserver.bulldozer import helper


MONGOURI = 'sas1-3155.search.yandex.net,ws30-522.yandex.ru,ws37-915.yandex.ru,ws41-365.yandex.ru,man1-1149.search.yandex.net'

NOT_GROUPS = ['MSK_MMETA_CONQUISTA', 'MSK_MMETA', 'MSK_SAAS_SEARCHPROXY', 'SAS_MMETA_CONQUISTA',
              'MSK_SAAS_INDEXER_PROXY', 'MSK_WEB_MMETA_HAMSTER']


def _group(tags):
    s = set()
    for tag in tags.split(' '):
        if tag.upper() == tag and not tag.startswith('ENV_'):
            s.add(tag)
    if len(s) > 1:
        for g in NOT_GROUPS:
            if g in s:
                s.remove(g)
    if len(s) > 0:
        return s.pop()
    return ''


def _version(tags):
    for tag in tags.split(' '):
        match = re.search(r'a_topology_stable-([0-9]*)-r([0-9]*)', tag)
        if match:
            return 1000000 * int(match.group(1)) + int(match.group(2))
    return 0


def main():
    rdb = pymongo.MongoReplicaSetClient(
        MONGOURI,
        connectTimeoutMS=500,
        replicaSet='autobalancing',
        w='majority',
        wtimeout=5000,
        read_preference=pymongo.ReadPreference.SECONDARY_PREFERRED,
    )['counters']['test1']

    com = helper.Communicator().ready()
    for host, _, data in com.read():
        try:
            pass
        except (TypeError, KeyError, ValueError) as ex:
            com.discard(repr(ex))
        else:
            com.ready()
