#!/skynet/python/bin/python

import time
import bson
import msgpack

import pkg_resources

pkg_resources.require('pymongo')

pkg_resources.require('skynet-heartbeat-server-service')
from ya.skynet.services.heartbeatserver.bulldozer import helper


def create_collection(db, name):
    c = db[name]
    c.ensure_index(
        [
            ('host', 1),
            ('ts', 1)
        ],
        unique=False
    )
    return c


TIMESTEP = 60 * 60


def main():
    com = helper.Communicator().ready()
    dbc = helper.ReportCollection('instanceusage', onCreate=create_collection)
    for host, _, data in com.read():
        try:
            ts = (int(time.time()) / TIMESTEP) * TIMESTEP
            report = data['report']

            dbc.coll.update(
                {'host': host, 'ts': ts},
                dict(
                    host=host, ts=ts,
                    binary=bson.binary.Binary(msgpack.packb(report))
                ),
                upsert=True
            )
        except (TypeError, KeyError, ValueError) as ex:
            com.discard(repr(ex))
        else:
            com.ready()
