#!/skynet/python/bin/python
import datetime
import pkg_resources

pkg_resources.require('pymongo')
pkg_resources.require('skynet-heartbeat-server-service')

REPORT_VERSION_1 = 1
VALID_REPORT_VERSIONS = (REPORT_VERSION_1, )

from ya.skynet.services.heartbeatserver.bulldozer import helper


def create_collection(db, name):
    c = db[name]
    c.ensure_index('host', unique=True)
    return c


def main():
    com = helper.Communicator().ready()
    dbc = helper.ReportCollection('last', onCreate=create_collection)

    for host, _, data in com.read():
        try:
            exists = dbc.coll.find_one({'host': host})
            if exists:
                report = exists
            else:
                report = {'host': host}

            report_version = data['report']['report_version']
            if report_version not in VALID_REPORT_VERSIONS:
                raise ValueError('report version: {} is not valid, available: {}'.format(
                    report_version, VALID_REPORT_VERSIONS))

            if report_version == REPORT_VERSION_1:
                report['user_sessions'] = data['report']['user_sessions']
                report['wtmp_begin_dt'] = data['report']['wtmp_begin_dt']
                report['user_sessions_seconds_length'] = data['report']['user_sessions_seconds_length']

            report.update({
                'report_version': report_version,
                'received': datetime.datetime.now(),
                'generated': datetime.datetime.fromtimestamp(data['end'])
            })

            dbc.update(host, report)

        except (TypeError, KeyError, ValueError) as ex:
            com.discard(repr(ex))
        else:
            com.ready()
