#!/skynet/python/bin/python
import datetime
import pkg_resources

pkg_resources.require('skynet-heartbeat-server-service')
from ya.skynet.services.heartbeatserver.bulldozer import helper


def create_collection(db, name):
    c = db[name]
    c.create_index('host')
    c.create_index('generated')
    c.create_index('received')
    return c


def main():
    dbc = helper.ReportCollection('sepe_lldpinfo', onCreate=create_collection)
    com = helper.Communicator().ready()

    try:
        for host, name, data in com.read():
            try:
                data['report'].update({'host': host,
                                       'generated': datetime.datetime.fromtimestamp(data['end']),
                                       'received': datetime.datetime.now(),
                                       })
                dbc.update(host, helper.fixKeys(data['report']))

            except (TypeError, KeyError, ValueError) as ex:
                com.discard(repr(ex))

            else:
                com.ready()
    finally:
        if dbc.bulk:
            dbc.bulk.execute()
