#!/skynet/python/bin/python

import pkg_resources

pkg_resources.require('pymongo')

pkg_resources.require('skynet-heartbeat-server-service')
from ya.skynet.services.heartbeatserver.bulldozer import helper


def create_collection(db, name):
    c = db[name]
    c.ensure_index('host', unique=True)
    return c


def main():
    com = helper.Communicator().ready()
    dbc = helper.ReportCollection('memleak', onCreate=create_collection)

    try:
        i = 0
        for host, _, data in com.read():
            # Process 20% of reports
            i += 1
            if i < 5:
                com.ready()
                continue
            else:
                i = 0

            try:
                dbc.update(host, {'leak': data['report']})
            except (TypeError, KeyError, ValueError) as ex:
                com.discard(repr(ex))
            else:
                com.ready()
    finally:
        if dbc.bulk:
            dbc.bulk.execute()
