#!/skynet/python/bin/python

import pkg_resources

pkg_resources.require('skynet-heartbeat-server-service')
from ya.skynet.services.heartbeatserver.bulldozer import helper


def main():
    dbc = helper.ReportCollection('metrics_copier')
    com = helper.Communicator().ready()

    for host, _, data in com.read():
        try:
            if data['report']:
                update = helper.fixKeys(data['report'])
                dbc.update(host, update)

            com.ready()
        except (KeyError, TypeError, ValueError) as ex:
            com.discard(repr(ex))
