#!/skynet/python/bin/python

import pkg_resources
import argparse

pkg_resources.require('skynet-heartbeat-server-service')
from ya.skynet.services.heartbeatserver.bulldozer import helper

import pymongo.errors


def create_collection(db, name):
    # 100 MB capped collection
    try:
        c = db.create_collection(name, size=100000000, capped=True)
    except pymongo.errors.OperationFailure:  # Collections exists
        c = db[name]
    c.create_index([('time', helper.pymongo.ASCENDING),
                    ('service', helper.pymongo.ASCENDING),
                    ],
                   name='time_service', unique=False)
    c.create_index([('time', helper.pymongo.ASCENDING),
                    ('service', helper.pymongo.ASCENDING),
                    ('host', helper.pymongo.ASCENDING),
                    ],
                   name='time_service_host', unique=False)
    return c


def parse_args():
    parser = argparse.ArgumentParser()
    parser.add_argument('-i', '--implementation', choices=('cqueue', 'cqudp'), default='cqueue')
    return parser.parse_args()


def main():
    args = parse_args()
    dbc = helper.ReportCollection('restart_metrics', onCreate=create_collection)

    com = helper.Communicator().ready()
    for host, _, data in com.read():
        try:
            if data['report']:
                for date_time in data['report']:
                    document = {
                        'host': host,
                        'service': args.implementation,
                        'time': ' '.join(date_time)
                    }
                    dbc.insert(document)

            com.ready()
        except (KeyError, TypeError, ValueError) as ex:
            com.discard(repr(ex))
