#!/skynet/python/bin/python

import pkg_resources
import argparse
import pymongo

pkg_resources.require('skynet-heartbeat-server-service')
from ya.skynet.services.heartbeatserver.bulldozer import helper

import pymongo.errors


def create_collection(db, name):
    # 100 MB capped collection
    try:
        c = db.create_collection(name, size=100000000, capped=True)
    except pymongo.errors.OperationFailure:  # Collections exists
        c = db[name]
    c.create_index([('time', pymongo.ASCENDING), ('service', pymongo.ASCENDING)], name='time_service', unique=False)
    return c


def parse_args():
    parser = argparse.ArgumentParser()
    parser.add_argument('-i', '--implementation', choices=('cqueue', 'cqudp'), default='cqueue')
    return parser.parse_args()


def main():
    args = parse_args()
    dbc = helper.ReportCollection('metrics', onCreate=create_collection)

    com = helper.Communicator().ready()
    for host, _, data in com.read():
        try:
            if data['report']:
                for document in data['report']:
                    if type(document) != dict:
                        # ignore old or invalid reports
                        continue
                    document['host'] = host
                    document['service'] = args.implementation
                    dbc.insert(document)

            com.ready()
        except (KeyError, TypeError, ValueError) as ex:
            com.discard(repr(ex))
