#!/skynet/python/bin/python

import pkg_resources
import pymongo

from collections import defaultdict

pkg_resources.require('skynet-heartbeat-server-service')  # noqa
from ya.skynet.services.heartbeatserver.bulldozer import helper


def create_collection(db, name):
    c = db[name]
    c.create_index([('restype', pymongo.ASCENDING)], unique=True)
    c.create_index([('total', pymongo.DESCENDING)], unique=False)
    return c


def main():
    dbc = helper.ReportCollection('restype_metrics', onCreate=create_collection)()

    com = helper.Communicator().ready()
    for host, _, data in com.read():
        try:
            if data['report']:
                restypes = defaultdict(int)
                for document in data['report']:
                    if type(document) != dict or document.get('type') != 'ResTypes':
                        # ignore old or invalid reports
                        continue
                    for report in document['records']:
                        restypes[report['name']] += report['count']
                if restypes:
                    bulk = dbc.initialize_unordered_bulk_op()
                    for name, total in restypes.iteritems():
                        bulk.find(
                            {'restype': name}
                        ).upsert().update_one(
                            {'$set': {'host': host}, '$inc': {'total': total}}
                        )
                    bulk.execute()

            com.ready()
        except (KeyError, TypeError, ValueError) as ex:
            com.discard(repr(ex))
