#!/skynet/python/bin/python

from collections import deque, defaultdict
import time
import pkg_resources
# import logging

pkg_resources.require('skynet-heartbeat-server-service')
from ya.skynet.services.heartbeatserver.bulldozer import helper  # noqa

import pymongo.errors


PREFIX_GROUPS = (
    'HISsdl',  # CMS
    'C',  # conf (cms or HQ)
    'KkPD',  # conductor
    'G',  # gencfg
    'W',  # walle
    'f',  # HQ
    'Q',  # qloud
)
REVERSE_GROUPS = {}
for group in PREFIX_GROUPS:
    for char in group:
        REVERSE_GROUPS[char] = group

BUCKET = 3600


def create_collection(db, name):
    # 100 MB capped collection
    try:
        c = db.create_collection(name, size=100000000, capped=True)
    except pymongo.errors.OperationFailure:  # Collections exists
        c = db[name]
    c.create_index([('timestamp', helper.pymongo.ASCENDING)])
    return c


def aggregate(dbc, first_time, records, documents):
    # at this moment of time we just ignore fields `username`
    for document in documents:
        ts = document['timestamp']
        tokens = defaultdict(int)

        idx = int(ts - first_time)
        if idx < 0 or idx >= BUCKET:
            continue

        for prefix in map(lambda x: x[0], document['tokens']):
            # logging.debug("found prefix %r at offset %d s", prefix, BUCKET - idx)
            tokens[prefix] += 1

        for token, count in tokens.items():
            if token in REVERSE_GROUPS:
                records[REVERSE_GROUPS[token]][idx] += count

    new_time = time.time()
    while new_time - first_time > BUCKET:
        for group in PREFIX_GROUPS:
            rate = records[group].popleft()
            if rate > 0:
                # logging.info("inserting group %r timestamp %r rate %r", group, int(first_time), rate)
                dbc.insert({
                    'timestamp': int(first_time),
                    'rate': rate,
                    'prefixes': group,
                })
            # else:
            #     logging.debug("skipping group %r timestamp %r, no rate", group, int(first_time))
            records[group].append(0)
        first_time += 1

    return first_time


def main():
    # logging.basicConfig(level=logging.DEBUG)
    dbc = helper.ReportCollection('resolver_metrics', onCreate=create_collection)
    records = {group: deque([0] * BUCKET) for group in PREFIX_GROUPS}
    first_time = time.time() - 3600

    com = helper.Communicator().ready()
    for host, _, data in com.read():
        try:
            if data['report'] and isinstance(data['report'], (list, tuple)):
                first_time = aggregate(dbc, first_time, records, data['report'])

            com.ready()
        except (KeyError, TypeError, ValueError) as ex:
            # logging.exception(str(ex), exc_info=1)
            com.discard(repr(ex))
