#!/skynet/python/bin/python

import pkg_resources

pkg_resources.require('skynet-heartbeat-server-service')
from ya.skynet.services.heartbeatserver.bulldozer import helper


def main():
    dbc = helper.ReportCollection('monitoring')

    com = helper.Communicator().ready()

    try:
        for host, _, data in com.read():
            try:
                report = helper.fixKeys(data['report'])
                update = {}

                for key, value in report.iteritems():
                    update['services.copier.report.%s' % (key, )] = value

                dbc.update(host, update)
            except (KeyError, TypeError, ValueError) as ex:
                com.discard(repr(ex))
            else:
                com.ready()
    finally:
        if dbc.bulk:
            dbc.bulk.execute()
