#!/skynet/python/bin/python

import pkg_resources
import argparse
import random

pkg_resources.require('skynet-heartbeat-server-service')
from ya.skynet.services.heartbeatserver.bulldozer import helper


def parse_args():
    parser = argparse.ArgumentParser()
    parser.add_argument('-i', '--implementation', choices=('cqueue', 'cqudp'), default='cqueue')
    return parser.parse_args()


def main():
    args = parse_args()
    dbc = helper.ReportCollection('monitoring')

    com = helper.Communicator().ready()

    try:
        for host, _, data in com.read():
            if random.random() < 0.8:
                com.ready()
                continue
            try:
                bulk = dbc.db.db.monitoring.initialize_unordered_bulk_op()
                for tgt_host, ping in data['report'].get('ping', {}).items():
                    update = {
                        'services.{}.ping'.format(args.implementation): ping
                    }
                    bulk.find({'host': tgt_host}).update({'$set': update})
                bulk.execute()
            except (KeyError, TypeError, ValueError) as ex:
                com.discard(repr(ex))
            else:
                com.ready()
    finally:
        if dbc.bulk:
            dbc.bulk.execute()
