#!/skynet/python/bin/python

import datetime

import pkg_resources

pkg_resources.require('skynet-heartbeat-server-service')  # noqa
from ya.skynet.services.heartbeatserver.bulldozer import helper


def main():
    dbc = helper.ReportCollection('oopsstat')
    com = helper.Communicator().ready()
    for host, _, data in com.read():
        try:
            now = datetime.datetime.now()
            report = {
                'report': {
                    'updated': now,
                    'generated': datetime.datetime.fromtimestamp(data['end']),
                }
            }
            for module, data in data['report'].get('modules', {}).iteritems():
                report.setdefault('module', {}).setdefault(module, {})['generated'] = datetime.datetime.fromtimestamp(data[0])
                report['module'][module]['traceback'] = data[1]

            dbc.update(host, report, bulk=True, replace=True)
        except (TypeError, KeyError, ValueError) as ex:
            com.discard(repr(ex))
        else:
            com.ready()
    if dbc.bulk:
        dbc.bulk.execute()
