#!/skynet/python/bin/python

import datetime
import random

import pkg_resources

pkg_resources.require('skynet-heartbeat-server-service')
from ya.skynet.services.heartbeatserver.bulldozer import helper


def create_collection(db, name):
    c = db[name]
    c.create_index('type')
    c.create_index('host')
    c.create_index('received', expireAfterSeconds=2700)
    return c


def main():
    dbc = helper.ReportCollection('pinger', onCreate=create_collection)
    com = helper.Communicator().ready()
    try:
        for host, _, data in com.read():
            if random.random() < 0.8:
                com.ready()
                continue

            try:
                report = data['report']
                fastbone = 'fb:ip6' in report
                ping = report['fb:ip6'] if fastbone else report.get('bb:ip4', {})
                if ping and 'error' not in report:
                    loss = (
                        ping.get('stats', {}).get('packetloss', None)
                        if ping.get('result', '') == 'SUCCESS' else
                        None
                    )
                    document = {
                        'loss': loss,
                        'host': report['source']['bb']['fqdn'],
                        'target': ping['target']['bb']['fqdn'],
                        'received': datetime.datetime.utcnow(),
                        'type': 'fastbone' if fastbone else 'backbone',
                    }
                    # KORUM: Is there any place to define shared constant with `heartbeat` component?
                    # The same value is used to build the web representation of the collected statistics.
                    if loss is None or loss > 95:
                        # 'error' entry in the report commonly means that there's some system network layer problems
                        # on the host, for example, source or destination host has no fastbone connected, so the
                        # fastbone report will contain the message like "Failed to fastbonize ... host: <some system
                        # error here>". Anyway, this means that ping between that two hosts is not possible.
                        document['error'] = (
                            ping['stderr'] or
                            ping['stdout'] if 'error' not in report else report['error']
                        )

                    # Ok, now filter out 'Operation not permitted' errors.
                    # ekoz@: This problem is specific for FreeBSD Jails only. It can be fixed by
                    #        allowing `security.jail.allow_raw_sockets` for a Jail and by
                    #        RESTARTING it. And the last point is a terrible haemorrhoid.
                    if 'socket: Operation not permitted' not in document.get('error', ''):
                        dbc.insert(document)
            except (TypeError, KeyError, ValueError) as ex:
                com.discard(repr(ex))
            else:
                com.ready()
    finally:
        if dbc.bulk:
            dbc.bulk.execute()
