#!/skynet/python/bin/python
import datetime
import random

import pkg_resources

pkg_resources.require('skynet-heartbeat-server-service')
from ya.skynet.services.heartbeatserver.bulldozer import helper


def create_collection(db, name):
    c = db[name]
    c.create_index('target')
    c.create_index('source')
    c.create_index('generated', expireAfterSeconds=3600)
    return c


def main():
    dbc = helper.ReportCollection('pinger2', onCreate=create_collection)
    com = helper.Communicator().ready()

    try:
        for host, _, data in com.read():
            try:
                data['report'].update({'generated': datetime.datetime.now()})
                dbc.coll.insert(data['report'])

            except (TypeError, KeyError, ValueError) as ex:
                com.discard(repr(ex))

            else:
                com.ready()
    finally:
        if dbc.bulk:
            dbc.bulk.execute()
