#!/skynet/python/bin/python

import hashlib

import bson
import pymongo

import pkg_resources

pkg_resources.require('skynet-heartbeat-server-service')
from ya.skynet.services.heartbeatserver.bulldozer import helper

import pymongo.errors


SUM_FIELDS = set(['error', 'returncode', 'stderr', 'stdout'])


def create_collection(db, name):
    try:
        c = db.create_collection(name, size=100 * 1 << 20, capped=True)
    except pymongo.errors.OperationFailure:  # Collections exists
        c = db[name]
    c.create_index([('host', pymongo.ASCENDING), ('sha1sum', pymongo.ASCENDING)], name='host_checksum', unique=True)
    return c


def main():
    dbcs = {}
    rdb = helper.ReportDatabase()
    com = helper.Communicator().ready()
    for host, _, data in com.read():
        try:
            report = data['report']
            plugin = report.pop('plugin')
            name = plugin['name'].lower()
            dbc = dbcs.get(name, None)

            if name in (
                'pinger',                  # temporary disable, makes mongo go crazy sometimes
                'instanceusagev2',         # nobody looks here :)
                'instanceusagev2_infreq',  # raises fassert in mongodb sometimes
                'lldpinfo',                # raises fassert in mongodb sometimes
            ):
                com.ready()
                continue

            if not dbc:
                dbc = dbcs[name] = helper.ReportCollection(
                    'pluginerror_%s' % name,
                    rdb=rdb,
                    onCreate=create_collection
                )

            sha1 = hashlib.sha1()
            for k, v in filter(lambda (k, v): k in SUM_FIELDS, report.iteritems()):
                sha1.update(str(v))

            if report.get('stdout', ''):
                report['stdout'] = bson.Binary(report['stdout'])

            if report.get('stderr', ''):
                report['stderr'] = bson.Binary(report['stderr'])

            dbc.update(
                {'host': host, 'sha1sum': sha1.hexdigest()}, report
            )

        except (TypeError, KeyError, ValueError) as ex:
            com.discard(repr(ex))
        else:
            com.ready()
