#!/skynet/python/bin/python

import datetime
import time

import pkg_resources

pkg_resources.require('skynet-heartbeat-server-service')
from ya.skynet.services.heartbeatserver.bulldozer import helper

import pymongo.errors


def create_collection(db, name):
    try:
        c = db.create_collection(name, size=1 << 30, capped=True)
    except pymongo.errors.OperationFailure:  # Collections exists
        c = db[name]
    c.create_index('generated')
    c.create_index('type')
    return c


def main():
    dbc = helper.ReportCollection('searchcrash', onCreate=create_collection)
    com = helper.Communicator().ready()
    prev_ts = 0
    for host, _, data in com.read():
        received_ts = time.time()

        if received_ts - prev_ts < 1.0:
            com.ready()
            continue

        prev_ts = received_ts

        try:
            report = data['report']
            if report.get('retcode', None) != 0:
                report.update({
                    'host': host,
                    'received': datetime.datetime.now(),
                    'generated': datetime.datetime.fromtimestamp(data['end']),
                })
                dbc.coll.insert(report)
        except (TypeError, KeyError, ValueError) as ex:
            com.discard(repr(ex))
        else:
            com.ready()
