#!/skynet/python/bin/python

import pkg_resources
import pymongo

pkg_resources.require('pymongo')

pkg_resources.require('skynet-heartbeat-server-service')
from ya.skynet.services.heartbeatserver.bulldozer import helper


def create_collection(db, name):
    c = db[name]
    c.ensure_index('shard', unique=True)
    return c


def main():
    com = helper.Communicator().ready()
    dbc = helper.ReportCollection('shardsize', onCreate=create_collection)
    for host, _, data in com.read():
        try:
            for name, shard in data['report'].iteritems():
                shard['host'] = host
                try:
                    dbc.update({'shard': name, 'mtime': {'$lt': shard['mtime']}}, helper.fixKeys(shard))
                except pymongo.errors.DuplicateKeyError:
                    pass
        except (TypeError, KeyError, ValueError) as ex:
            com.discard(repr(ex))
        else:
            com.ready()
