#!/skynet/python/bin/python

import datetime

import pkg_resources

pkg_resources.require('skynet-heartbeat-server-service')
from ya.skynet.services.heartbeatserver.bulldozer import helper

import pymongo.errors


def create_collection(db, name):
    # 1GB limit
    try:
        c = db.create_collection(name, size=1 << 30, capped=True)
    except pymongo.errors.OperationFailure:  # Collections exists
        c = db[name]
    c.create_index('processed')
    return c


def main():
    dbc = helper.ReportCollection('skystat', onCreate=create_collection)
    com = helper.Communicator().ready()
    for host, _, data in com.read():
        try:
            report = {'data': data['report']}

            report.update({
                'host': host,
                'received': datetime.datetime.now(),
                'generated': datetime.datetime.fromtimestamp(data['end']),
                'processed': False
            })

            dbc.coll.insert(report)
        except (TypeError, KeyError, ValueError) as ex:
            com.discard(repr(ex))
        else:
            com.ready()
