#!/skynet/python/bin/python

import logging
import json
from sending import InstanceUsageBufferingSender
from common import InstanceTypes

logging.basicConfig(level=logging.DEBUG)


def is_bad_report(report):
    return any(v is None for v in report.itervalues())


def push_instanceusage_query(report_type, hosts_and_reports):
    other_labels = {
        InstanceTypes.ISS: ['host', 'port', 'group', 'major_tag', 'minor_tag', 'version'],
        InstanceTypes.HOST: ['host'],
        InstanceTypes.QLOUD: ['host', 'port', 'service', 'environ', 'app', 'project', 'install_type'],
        InstanceTypes.OPENSTACK: ['host', 'port', 'tenant_id'],
        InstanceTypes.YP: ['host', 'port', 'group'],
    }
    sensors = {
        InstanceTypes.ISS: [
            'instance_mem_usage',
            'instance_cpu_usage',
            'instance_anon_mem_usage',
            'instance_net_rx_usage',
            'instance_net_tx_usage'
        ],
        InstanceTypes.HOST: [
            'instance_mem_usage',
            'instance_cpu_usage',
            'hdd_total',
            'hdd_usage',
            'ssd_total',
            'ssd_usage'
        ],
        InstanceTypes.QLOUD: [
            'instance_mem_usage',
            'instance_cpu_usage',
            'instance_net_rx_usage',
            'instance_net_tx_usage'
        ],
        InstanceTypes.OPENSTACK: [
            'instance_mem_usage',
            'instance_cpu_usage'
        ],
        InstanceTypes.YP: [
            'instance_mem_usage',
            'instance_mem_guarantee',
            'instance_cpu_usage',
            'instance_cpu_guarantee',
            'instance_anon_mem_usage',
            'instance_net_rx_usage',
            'instance_net_tx_usage'
        ],
    }
    for host, report in hosts_and_reports:
        report['host'] = host
        for s in sensors[report_type]:
            data = dict()
            data['sensors'] = list()
            try:
                labels_dict = dict([(l, report[l]) for l in other_labels[report_type]])
                labels_dict['sensor'] = s
                data['sensors'].append({'labels': labels_dict, 'ts': int(report['ts']), 'value': report[s]})
                yield json.dumps(data)
            except Exception as e:
                logging.error("Got an error %s", str(e))


def generate_solomon_query(report_type, hosts_and_reports):
    if report_type not in InstanceTypes.ALL:
        logging.error("Unknown report type %s", report_type)
    else:
        good_hosts_and_reports = [(host, report) for host, report in hosts_and_reports if not is_bad_report(report)]

        if len(good_hosts_and_reports) != len(hosts_and_reports):
            logging.error("Dropping %i reports with Nones!", len(hosts_and_reports) - len(good_hosts_and_reports))

        return list(push_instanceusage_query(report_type, good_hosts_and_reports))


def main():
    slms = InstanceUsageBufferingSender(
        ['solomon.yandex.net'],
        generate_solomon_query,
        avg_seconds_between_queries=0.0,
        extra_data={'project': 'gencfg', 'cluster': 'instanceusage', 'service': 'instanceusage'},
        headers={'Content-Type': 'application/json'}
    )
    slms.run()
