#!/skynet/python/bin/python

import os
import logging
from sending import parse_hosts_from_url, InfreqBufferingSender

logging.basicConfig(level=logging.DEBUG)


def report_to_values(template, host, report):
    try:
        values = template.format(host=host, **report)
        return "({})".format(values)
    except KeyError:
        return None


def insert_query(values_template, query_template, hosts_and_reports):
    values = [
        report_to_values(values_template, host, report)
        for host, report in hosts_and_reports
        if report.get('version') == 2
    ]
    good_values = filter(None, values)
    if len(values) != len(good_values):
        logging.warn('dropping %i reports', len(values) - len(good_values))
    if not good_values:
        return None
    return query_template.format(values=", ".join(good_values))


def generate_clickhouse_query(hosts_and_reports):
    values_template = (
        "'{host}', {port}, {ts}, '{group}', '{formatted_date}', {major_tag}, {minor_tag}, {version}, "
        "{workdir_hdd_size}, {workdir_ssd_size}, {iss_resources_hdd_size}, {iss_resources_ssd_size}, "
        "{iss_shards_hdd_size}, {iss_shards_ssd_size}, {webcache_hdd_size}, {webcache_ssd_size}, "
        "{callisto_hdd_size}, {callisto_ssd_size}, {logs_hdd_size}, {logs_ssd_size}, '{volumes_size}'"
    )
    query_template = """
        INSERT INTO instanceusage_infreq_v2 (
            host, port, ts, group, eventDate,
            major_tag, minor_tag, version,
            workdir_hdd_size, workdir_ssd_size,
            iss_resources_hdd_size, iss_resources_ssd_size,
            iss_shards_hdd_size, iss_shards_ssd_size,
            webcache_hdd_size, webcache_ssd_size,
            callisto_hdd_size, callisto_ssd_size,
            logs_hdd_size, logs_ssd_size, volumes_size
        ) VALUES {values}
    """

    return [insert_query(values_template, query_template, hosts_and_reports)]


def main():
    chs = InfreqBufferingSender(
        parse_hosts_from_url(os.environ['DATABASE_URI']),  # gencfg clickhouse in dbaas
        generate_clickhouse_query,
        avg_seconds_between_queries=5.0,
    )
    chs.run()
