#!/skynet/python/bin/python
import datetime
import pkg_resources

pkg_resources.require('pymongo')
pkg_resources.require('skynet-heartbeat-server-service')

REPORT_VERSION_1 = 1
REPORT_VERSION_2 = 2
VALID_REPORT_VERSIONS = (REPORT_VERSION_1, REPORT_VERSION_2)

from ya.skynet.services.heartbeatserver.bulldozer import helper


def create_collection(db, name):
    c = db[name]
    c.ensure_index('host', unique=True)
    return c


def main():
    com = helper.Communicator().ready()
    dbc = helper.ReportCollection('who', onCreate=create_collection)
    for host, _, data in com.read():
        try:
            exists = dbc.coll.find_one({'host': host})
            if exists:
                report = exists
            else:
                report = {'host': host, 'user_sessions': {}, 'user_actions': {},
                          'initialised': datetime.datetime.now()}

            report_version = data['report']['report_version']
            if report_version not in VALID_REPORT_VERSIONS:
                raise ValueError('report version: {} is not valid, available: {}'.format(
                    report_version, VALID_REPORT_VERSIONS))

            if report_version in (REPORT_VERSION_1, REPORT_VERSION_2):
                report['user_sessions'].update(data['report']['user_sessions'])

            if report_version == REPORT_VERSION_2:
                if 'user_actions' not in report:
                    report['user_actions'] = {}
                report['user_actions'].update(data['report']['user_actions'])

            report.update({
                'report_version': report_version,
                'received': datetime.datetime.now(),
                'generated': datetime.datetime.fromtimestamp(data['end'])
            })

            dbc.update(host, report)

        except (TypeError, KeyError, ValueError) as ex:
            com.discard(repr(ex))
        else:
            com.ready()
