""" Misc utils. """

import urlparse


def dbName(urlStr):
    """
    Parses given URL of MongoDB connection format to fetch out database name from ir.
    :param urlStr: MongoDB connection URL.
    :return: Database name
    """
    url = urlparse.urlparse(urlStr)
    if not url.scheme or url.scheme != 'mongodb' or not url.path:
        raise Exception("Database URI %r passed is invalid." % urlStr)

    # Follows a block of code to workaround a problem with Python 2.6's `urlparse` bug -
    # it does not strips query parameters out from `path` attribute to appropriate `query` attribute.
    dbname = url.path
    at = dbname.find('?')
    if at > 0:
        dbname = dbname[:at]
    return dbname.strip('/')
