import os

try:
    from setuptools import setup, find_packages
except ImportError:
    import sys
    print >> sys.stderr, 'Please install distribute from PyPi first.'
    exit(1)

from setuptools.command.install import install
from setuptools.command.bdist_egg import log
try:
    from setuptools.command.bdist_egg import NS_PKG_STUB
except ImportError:
    NS_PKG_STUB = '__import__("pkg_resources").declare_namespace(__name__)'


class InstallCommand(install):
    def run(self):
        install.run(self)

        for path, dirs, files in os.walk(self.install_purelib):
            if path == self.install_purelib:
                continue

            if '__init__.py' not in files:
                pkg = path[len(self.install_purelib):].replace(os.sep, '.')
                if self.distribution.has_contents_for(pkg):
                    log.warn('Creating missing __init__.py for %s', pkg)
                    fn = os.path.join(path, '__init__.py')
                    if not self.dry_run:
                        with open(fn, 'w') as f:
                            f.write(NS_PKG_STUB + '\n')

setup(
    name='heartbeat',
    version='1.0',
    description='Skynet HeartBeat Service',
    install_requires=[
        'PyYAML',
        'msgpack-python',
        'faulthandler',
        'pymongo',
        'flask',
    ],
    packages=(
        ['heartbeat'] +
        ['heartbeat.%s' % pkg for pkg in find_packages('src')]
    ),
    package_dir={
        'heartbeat': 'src',
    },
    entry_points={
        'console_scripts': [
            'daemon = heartbeat.daemon.daemon:main',
            'check = heartbeat.daemon.check:main',
            'stop = heartbeat.daemon.stop:main',
        ],
    },
    cmdclass={'install': InstallCommand}
)
