class Type(type):
    def __new__(mcs, value):
        if value == 'undef':
            return None
        return value


class OkType(Type):
    def __new__(mcs, value):
        value = Type(value)
        if value is None:
            return
        if value == 'OK' or value is True:
            return True
        elif value is False:
            return False
        else:
            return TextType(value)


class Md5Type(Type):
    def __new__(mcs, value):
        value = Type(value)
        if value is None:
            return

        if len(value) == 32:
            try:
                return value.decode('hex')
            except:
                return None


class ChkSumType(Md5Type):
    def __new__(mcs, value):
        if value.startswith('MD5:'):
            value = value[4:]
        return Md5Type.__new__(Md5Type, value)


class IntType(Type):
    def __new__(mcs, value):
        value = Type(value)
        if value is None:
            return
        try:
            return int(value)
        except:
            return


class TextType(Type):
    def __new__(mcs, value):
        value = Type(value)
        if value is None:
            return ''
        try:
            return str(value)
        except:
            return ''


STATE_FIELDS = {
    'created': ('\x00', IntType),
    'defer': ('\x01', IntType),
    'acquire': ('\x02', OkType),
    'sky-result': ('\x03', OkType),
    'skytries': ('\x04', IntType),
    'install': ('\x05', OkType),
    'generated_chksum': ('\x06', Md5Type),
    'handmade': ('\x07', OkType),
    'defer-waitlist': ('\x08', TextType),
    'remove': ('\x09', TextType),
    'conf_mtime': ('\x0a', IntType),
    'chksum': ('\xff', ChkSumType),
}


def compactState(state, hint=None):
    newState = {}
    for key, value in state.items():
        if key in STATE_FIELDS:
            idx, typ = STATE_FIELDS[key]
            value = typ(value)
            if value is not None and value != '':
                newState[idx] = value
        else:
            newState[key] = value

    return newState
