package main

import (
	yaml "a.yandex-team.ru/infra/orly/go/orly/yamlutil"
	"io/ioutil"
)

type ClusterConfig struct {
	Nodes        []string `json:"nodes"`
	MaxSQLMemory string   `json:"max_sql_memory"`
	DataDir      string   `json:"data_dir"`
}

func ReadConfig(path string) (*ClusterConfig, error) {
	c := &ClusterConfig{}
	yamlFile, err := ioutil.ReadFile(path)
	if err != nil {
		return nil, err
	}
	err = yaml.Unmarshal(yamlFile, c)
	if err != nil {
		return nil, err
	}
	return c, nil
}
