package main

import (
	"bytes"
	"log"
	"text/template"
)

func createCACert(l *log.Logger) error {
	tmpl, err := getTemplate("create-ca-cert.sh.tmpl")
	if err != nil {
		return err
	}
	data := struct{ TmpRoot string }{
		TmpRoot: tmpRoot,
	}
	buf := &bytes.Buffer{}
	t := template.Must(template.New("data").Parse(tmpl))
	err = t.Execute(buf, data)
	if err != nil {
		return err
	}
	err = execScript(l, buf)
	if err != nil {
		return err
	}
	return nil
}

func prepareCertsDirectories(l *log.Logger, outDir string) error {
	tmpl, err := getTemplate("prepare-certs-dirs.sh.tmpl")
	if err != nil {
		return err
	}
	data := struct {
		TmpRoot  string
		CertsDir string
	}{
		TmpRoot:  tmpRoot,
		CertsDir: outDir,
	}
	buf := &bytes.Buffer{}
	t := template.Must(template.New("data").Parse(tmpl))
	err = t.Execute(buf, data)
	if err != nil {
		return err
	}
	err = execScript(l, buf)
	if err != nil {
		return err
	}
	return nil
}

func createNodeCerts(l *log.Logger, outDir, node string) error {
	tmpl, err := getTemplate("create-node-certs.sh.tmpl")
	if err != nil {
		return err
	}
	data := struct {
		TmpRoot  string
		CertsDir string
		NodeName string
	}{
		TmpRoot:  tmpRoot,
		CertsDir: outDir,
		NodeName: node,
	}
	buf := &bytes.Buffer{}
	t := template.Must(template.New("data").Parse(tmpl))
	err = t.Execute(buf, data)
	if err != nil {
		return err
	}
	err = execScript(l, buf)
	if err != nil {
		return err
	}
	return nil
}

func createClientCert(l *log.Logger, outDir, node, client string) error {
	tmpl, err := getTemplate("create-client-node-certs.sh.tmpl")
	if err != nil {
		return err
	}
	data := struct {
		TmpRoot    string
		CertsDir   string
		NodeName   string
		ClientName string
	}{
		TmpRoot:    tmpRoot,
		CertsDir:   outDir,
		NodeName:   node,
		ClientName: client,
	}
	buf := &bytes.Buffer{}
	t := template.Must(template.New("data").Parse(tmpl))
	err = t.Execute(buf, data)
	if err != nil {
		return err
	}
	err = execScript(l, buf)
	if err != nil {
		return err
	}
	return nil
}
func clearTmpDirectory(l *log.Logger, certsDir string) error {
	tmpl, err := getTemplate("clear-tmp-dir.sh.tmpl")
	if err != nil {
		return err
	}
	data := struct {
		TmpRoot  string
		CertsDir string
	}{
		TmpRoot:  tmpRoot,
		CertsDir: certsDir,
	}
	buf := &bytes.Buffer{}
	t := template.Must(template.New("data").Parse(tmpl))
	err = t.Execute(buf, data)
	if err != nil {
		return err
	}
	err = execScript(l, buf)
	if err != nil {
		return err
	}
	return nil
}

func createClusterCerts(nodes, clients []string, outDir string, l *log.Logger) error {
	err := prepareCertsDirectories(l, outDir)
	if err != nil {
		return err
	}
	err = createCACert(l)
	if err != nil {
		return err
	}
	for _, node := range nodes {
		err = createNodeCerts(l, outDir, node)
		if err != nil {
			return err
		}
		for _, client := range clients {
			err = createClientCert(l, outDir, node, client)
			if err != nil {
				return err
			}
		}
	}
	err = clearTmpDirectory(l, outDir)
	return err
}
