package main

import (
	"a.yandex-team.ru/infra/hmserver/pkg/reporter/client"
	"encoding/json"
	"fmt"
	"log"
	"os"

	"github.com/spf13/cobra"
)

func Execute() {
	var rootCmd = &cobra.Command{
		Use: "hm-reporterctl",
	}
	addresses := make([]string, 0)

	getClient := func() *client.Reporter {
		return client.NewClusterReporter(addresses)
	}

	cmdUnit := &cobra.Command{
		Use:   "unit <unit>",
		Short: "Get unit",
		Args:  cobra.ExactArgs(1),
		Run: func(cmd *cobra.Command, args []string) {
			c := getClient()
			status, err := c.GetUnit(args[0])
			if err != nil {
				er(err)
			}
			jstatus, err := json.MarshalIndent(status, "", "  ")
			if err != nil {
				er(err)
			}
			fmt.Println(string(jstatus))
		},
	}

	cmdList := &cobra.Command{
		Use:   "list",
		Short: "List units",
		Args:  cobra.NoArgs,
		Run: func(cmd *cobra.Command, args []string) {
			c := getClient()
			versions, err := c.GetUnits()
			if err != nil {
				er(err)
			}
			jversions, err := json.MarshalIndent(versions, "", "  ")
			if err != nil {
				er(err)
			}
			fmt.Println(string(jversions))
		},
	}

	reportsOpts := struct {
		node  string
		unit  string
		stage string
	}{}

	cmdHostReports := &cobra.Command{
		Use:   "reports",
		Short: "Get reports",
		Args:  cobra.ExactArgs(1),
		Run: func(cmd *cobra.Command, args []string) {
			c := getClient()
			reports, err := c.GetReports(reportsOpts.unit, reportsOpts.node, reportsOpts.stage)
			if err != nil {
				er(err)
			}
			jreports, err := json.MarshalIndent(reports, "", "  ")
			if err != nil {
				er(err)
			}
			fmt.Println(string(jreports))
		},
	}
	reportsFlags := cmdHostReports.Flags()

	reportsFlags.StringVar(&reportsOpts.unit, "unit", reportsOpts.unit, "Filter by unit name")
	reportsFlags.StringVar(&reportsOpts.stage, "stage", reportsOpts.stage, "Filter by stage")
	reportsFlags.StringVar(&reportsOpts.node, "node", reportsOpts.node, "Filter by node")

	rootCmd.PersistentFlags().StringSliceVar(&addresses, "address", []string{"localhost:8080"}, "")

	rootCmd.AddCommand(cmdUnit)
	rootCmd.AddCommand(cmdList)
	rootCmd.AddCommand(cmdHostReports)

	if err := rootCmd.Execute(); err != nil {
		log.Println(err)
		os.Exit(1)
	}
}

func er(err error) {
	log.Println(err)
	os.Exit(1)
}
