package main

import (
	"a.yandex-team.ru/infra/hmserver/pkg/reporter/server"
	"a.yandex-team.ru/infra/hmserver/pkg/reporter/storage"
	"github.com/spf13/cobra"
	"log"
	"os"
	"time"
)

func Execute() {
	var rootCmd = &cobra.Command{
		Use:   "hm-reporter-server",
		Short: "Hostman reporter server is a HTTP server, which handle units reports from hosts.",
	}
	l := log.New(os.Stdout, "", log.Lshortfile)
	addr := ""
	grpcAddr := ""
	debug := false
	maxIdleConns := 30
	maxConnLifetime := 0
	cmdStart := &cobra.Command{
		Use:   "start",
		Short: "Start reporter server",
		Run: func(cmd *cobra.Command, args []string) {
			dbAddr := os.Getenv("DB_ADDRESS")
			dbAdminAddr := os.Getenv("DB_ADMIN_ADDRESS")
			dbName := os.Getenv("DB_NAME")
			dbUser := os.Getenv("DB_USER")
			dbPassword := os.Getenv("DB_PASSWORD")
			dbConfig := &storage.Config{
				Addr:            dbAddr,
				AdminAddr:       dbAdminAddr,
				DBName:          dbName,
				User:            dbUser,
				Password:        dbPassword,
				MaxIdleConns:    maxIdleConns,
				MaxConnLifetime: time.Duration(maxConnLifetime) * time.Second,
			}
			err := server.RunReporter(l, addr, grpcAddr, dbConfig, debug)
			if err != nil {
				l.Println(err)
			}
		},
	}

	cmdStart.Flags().StringVar(&addr, "address", "[::]:8080", "address to listen to")
	cmdStart.Flags().StringVar(&grpcAddr, "grpc-address", "[::]:8081", "grpc address to listen to")
	cmdStart.Flags().IntVar(&maxIdleConns, "max-idle-conns", maxIdleConns, "maximum number of connections in the idle connection pool")
	cmdStart.Flags().IntVar(&maxConnLifetime, "max-conn-lifetime", maxConnLifetime, "sets the maximum amount of time a connection may be reused (in seconds)")
	cmdStart.Flags().BoolVar(&debug, "debug", debug, "debug mode: enable pprof paths")
	rootCmd.AddCommand(cmdStart)

	if err := rootCmd.Execute(); err != nil {
		l.Println(err)
		os.Exit(1)
	}
}
