package main

import (
	"fmt"
	"log"
	"os"

	"github.com/spf13/cobra"

	"a.yandex-team.ru/infra/hmserver/pkg/app"
	"a.yandex-team.ru/infra/hmserver/pkg/sync"
)

type directoryConfig struct {
	path     string
	listener string
}

var dc directoryConfig

func validateDirectoryConfig(c *directoryConfig) error {
	info, err := os.Stat(c.path)
	if err != nil {
		return err
	}
	if !info.IsDir() {
		return fmt.Errorf("%s is not a directory", c.path)
	}
	return nil
}

func runDirectory(c *directoryConfig) error {
	l := log.New(os.Stdout, "", log.LstdFlags|log.Lmicroseconds|log.Lshortfile)
	if err := validateDirectoryConfig(&dc); err != nil {
		l.Println("Error:", err)
		os.Exit(1)
	}
	ds := sync.NewDirectory(dc.path)
	return app.NewProduction(l, c.listener, ds).Run()
}

func registerDirectory(root *cobra.Command) {
	cmd := &cobra.Command{
		Use:   "directory",
		Short: "Serve specified directory as salt repo",
		RunE: func(cmd *cobra.Command, args []string) error {
			return runDirectory(&dc)
		},
	}
	cmd.Flags().StringVar(&dc.listener, "address", "[::]:8080", "address to listen to")
	cmd.Flags().StringVar(&dc.path, "path", "", "directory with salt repo (required)")
	_ = cmd.MarkFlagRequired("path")
	root.AddCommand(cmd)
}
