package main

import (
	"log"
	"os"

	"github.com/spf13/cobra"
)

func Execute() {
	var rootCmd = &cobra.Command{
		Use:          "hm-server",
		Short:        "Hostman server is a HTTP server, which serves salt repo as zip.",
		SilenceUsage: true,
	}
	registerProduction(rootCmd)
	registerDirectory(rootCmd)
	registerMulti(rootCmd)
	if err := rootCmd.Execute(); err != nil {
		log.Println(err)
		os.Exit(1)
	}
}
