package api

import (
	"net/http"
	"testing"
	"time"
)

func Test_checkIfModifiedSince(t *testing.T) {
	r, _ := http.NewRequest("POST", "/", nil)
	if checkIfModifiedSince(r, time.Time{}) != condNone {
		t.Error("POST is not condNone")
	}
	r, _ = http.NewRequest("GET", "/", nil)
	r.Header.Set("If-Modified-Since", "Wed, 07 Aug 2019 13:34:10 GMT")
	modtime := time.Unix(1565184850, 0)
	if cond := checkIfModifiedSince(r, modtime); cond != condFalse {
		t.Error("Unexpected cond: ", cond)
	}
}
