package api

import (
	"log"
	"net/http"
	"strconv"

	"a.yandex-team.ru/library/go/yandex/unistat"
)

type UnistatHandler struct {
	l *log.Logger
}

func NewUnistat(l *log.Logger) *UnistatHandler {
	return &UnistatHandler{
		l: l,
	}
}
func (u *UnistatHandler) Handle(w http.ResponseWriter, r *http.Request) {
	buf, err := unistat.MarshalJSON()
	if err != nil {
		w.WriteHeader(500)
		_, _ = w.Write([]byte(err.Error()))
	} else {
		w.Header().Set("Content-Type", "application/json")
		w.Header().Set("Content-Length", strconv.Itoa(len(buf)))
		if _, err := w.Write(buf); err != nil {
			u.l.Println("Failed to write response:", err)
		}
	}
}

func (u *UnistatHandler) Register(bind func(method, pattern string, h http.HandlerFunc)) {
	bind("GET", "/unistat", u.Handle)
}
