package bitbucket

import (
	"fmt"
	"testing"
)

func Test_formatZipURL(t *testing.T) {
	c := Client{
		project: "RTCSALT",
		repo:    "saltstack",
		branch:  "master_sas",
	}
	at := "e7f209317c1e51aaf20000a8d33bb41eb022dd26"
	expect := fmt.Sprintf("/rest/api/latest/projects/RTCSALT/repos/saltstack/archive?at=%s&format=zip", at)
	if rel := c.formatZipURL(at); rel != expect {
		t.Fatalf("Invalid URL: '%s' != '%s'", rel, expect)
	}
}

func Test_formatLastCommitURL(t *testing.T) {
	c := Client{
		project: "RTCSALT",
		repo:    "saltstack",
		branch:  "master_sas",
	}
	expect := "/rest/api/latest/projects/RTCSALT/repos/saltstack/commits?limit=1&until=refs%2Fheads%2Fmaster_sas"
	if rel := c.formatLastCommitURL(); rel != expect {
		t.Fatalf("Invalid URL: '%s' != '%s'", rel, expect)
	}
}
