package bitbucket

import "context"

/* Mock to be used in unit tests */
type FakeBB struct {
	GetLastCommitFun func(ctx context.Context) (*CommitInfo, error)
	ZipArchiveFun    func(ctx context.Context, at string) ([]byte, error)
}

func (f *FakeBB) GetLastCommit(ctx context.Context) (*CommitInfo, error) {
	return f.GetLastCommitFun(ctx)
}

func (f *FakeBB) ZipArchive(ctx context.Context, at string) ([]byte, error) {
	return f.ZipArchiveFun(ctx, at)
}
