package api

type RangesResponse struct {
	Ranges []Ranges `json:"ranges"`
}
type Span struct {
	StartKey string `json:"startKey"`
	EndKey   string `json:"endKey"`
}
type HardState struct {
	Term   string `json:"term"`
	Vote   string `json:"vote"`
	Commit string `json:"commit"`
}
type Progress struct {
}
type RaftState struct {
	ReplicaID      string    `json:"replicaId"`
	HardState      HardState `json:"hardState"`
	Lead           string    `json:"lead"`
	State          string    `json:"state"`
	Applied        string    `json:"applied"`
	Progress       Progress  `json:"progress"`
	LeadTransferee string    `json:"leadTransferee"`
}
type InternalReplicas struct {
	NodeID    int         `json:"nodeId"`
	StoreID   int         `json:"storeId"`
	ReplicaID int         `json:"replicaId"`
	Type      interface{} `json:"type"`
}
type RangeDesc struct {
	RangeID                        string             `json:"rangeId"`
	StartKey                       interface{}        `json:"startKey"`
	EndKey                         interface{}        `json:"endKey"`
	InternalReplicas               []InternalReplicas `json:"internalReplicas"`
	NextReplicaID                  int                `json:"nextReplicaId"`
	Generation                     string             `json:"generation"`
	DeprecatedGenerationComparable bool               `json:"deprecatedGenerationComparable"`
	StickyBit                      interface{}        `json:"stickyBit"`
}
type Start struct {
	WallTime string `json:"wallTime"`
	Logical  int    `json:"logical"`
}
type RangeExpiration struct {
	WallTime string `json:"wallTime"`
	Logical  int    `json:"logical"`
}
type Replica struct {
	NodeID    int         `json:"nodeId"`
	StoreID   int         `json:"storeId"`
	ReplicaID int         `json:"replicaId"`
	Type      interface{} `json:"type"`
}
type DeprecatedStartStasis struct {
	WallTime string `json:"wallTime"`
	Logical  int    `json:"logical"`
}
type ProposedTS struct {
	WallTime string `json:"wallTime"`
	Logical  int    `json:"logical"`
}
type Lease struct {
	Start                 Start                 `json:"start"`
	Expiration            Expiration            `json:"expiration"`
	Replica               Replica               `json:"replica"`
	DeprecatedStartStasis DeprecatedStartStasis `json:"deprecatedStartStasis"`
	ProposedTS            ProposedTS            `json:"proposedTs"`
	Epoch                 string                `json:"epoch"`
	Sequence              string                `json:"sequence"`
}
type TruncatedState struct {
	Index string `json:"index"`
	Term  string `json:"term"`
}
type GcThreshold struct {
	WallTime string `json:"wallTime"`
	Logical  int    `json:"logical"`
}
type RangeStats struct {
	ContainsEstimates string `json:"containsEstimates"`
	LastUpdateNanos   string `json:"lastUpdateNanos"`
	IntentAge         string `json:"intentAge"`
	GcBytesAge        string `json:"gcBytesAge"`
	LiveBytes         string `json:"liveBytes"`
	LiveCount         string `json:"liveCount"`
	KeyBytes          string `json:"keyBytes"`
	KeyCount          string `json:"keyCount"`
	ValBytes          string `json:"valBytes"`
	ValCount          string `json:"valCount"`
	IntentBytes       string `json:"intentBytes"`
	IntentCount       string `json:"intentCount"`
	SysBytes          string `json:"sysBytes"`
	SysCount          string `json:"sysCount"`
	AbortSpanBytes    string `json:"abortSpanBytes"`
}
type State struct {
	RaftAppliedIndex     string         `json:"raftAppliedIndex"`
	LeaseAppliedIndex    string         `json:"leaseAppliedIndex"`
	Desc                 RangeDesc      `json:"desc"`
	Lease                Lease          `json:"lease"`
	TruncatedState       TruncatedState `json:"truncatedState"`
	GcThreshold          GcThreshold    `json:"gcThreshold"`
	Stats                RangeStats     `json:"stats"`
	UsingAppliedStateKey bool           `json:"usingAppliedStateKey"`
}
type ClosedTimestamp struct {
	WallTime string `json:"wallTime"`
	Logical  int    `json:"logical"`
}
type NewestClosedTimestamp struct {
	NodeID          int             `json:"nodeId"`
	ClosedTimestamp ClosedTimestamp `json:"closedTimestamp"`
	Mlai            string          `json:"mlai"`
	Epoch           string          `json:"epoch"`
}
type ActiveClosedTimestamp struct {
	WallTime string `json:"wallTime"`
	Logical  int    `json:"logical"`
}
type RangeState struct {
	State                     State                 `json:"state"`
	LastIndex                 string                `json:"lastIndex"`
	NumPending                string                `json:"numPending"`
	NumDropped                string                `json:"numDropped"`
	RaftLogSize               string                `json:"raftLogSize"`
	RaftLogSizeTrusted        bool                  `json:"raftLogSizeTrusted"`
	ApproximateProposalQuota  string                `json:"approximateProposalQuota"`
	ProposalQuotaBaseIndex    string                `json:"proposalQuotaBaseIndex"`
	ProposalQuotaReleaseQueue []interface{}         `json:"proposalQuotaReleaseQueue"`
	RangeMaxBytes             string                `json:"rangeMaxBytes"`
	NewestClosedTimestamp     NewestClosedTimestamp `json:"newestClosedTimestamp"`
	ActiveClosedTimestamp     ActiveClosedTimestamp `json:"activeClosedTimestamp"`
	RangefeedRegistrations    string                `json:"rangefeedRegistrations"`
	TenantID                  string                `json:"tenantId"`
	LockTable                 string                `json:"lockTable"`
}
type LeaseHistory struct {
	Start                 Start                 `json:"start"`
	Expiration            Expiration            `json:"expiration"`
	Replica               Replica               `json:"replica"`
	DeprecatedStartStasis DeprecatedStartStasis `json:"deprecatedStartStasis"`
	ProposedTS            ProposedTS            `json:"proposedTs"`
	Epoch                 string                `json:"epoch"`
	Sequence              string                `json:"sequence"`
}
type Problems struct {
	Unavailable            bool `json:"unavailable"`
	LeaderNotLeaseHolder   bool `json:"leaderNotLeaseHolder"`
	NoRaftLeader           bool `json:"noRaftLeader"`
	Underreplicated        bool `json:"underreplicated"`
	Overreplicated         bool `json:"overreplicated"`
	NoLease                bool `json:"noLease"`
	QuiescentEqualsTicking bool `json:"quiescentEqualsTicking"`
	RaftLogTooLarge        bool `json:"raftLogTooLarge"`
}
type Stats struct {
	QueriesPerSecond int     `json:"queriesPerSecond"`
	WritesPerSecond  float64 `json:"writesPerSecond"`
}
type LatchesLocal struct {
	ReadCount  string `json:"readCount"`
	WriteCount string `json:"writeCount"`
}
type LatchesGlobal struct {
	ReadCount  string `json:"readCount"`
	WriteCount string `json:"writeCount"`
}
type Timestamp struct {
	WallTime string `json:"wallTime"`
	Logical  int    `json:"logical"`
}
type Liveness struct {
	NodeID     int        `json:"nodeId"`
	Epoch      string     `json:"epoch"`
	Expiration Expiration `json:"expiration"`
	Draining   bool       `json:"draining"`
	Membership int        `json:"membership"`
}
type LeaseStatus struct {
	Lease     Lease     `json:"lease"`
	Timestamp Timestamp `json:"timestamp"`
	State     int       `json:"state"`
	Liveness  Liveness  `json:"liveness"`
}
type Ranges struct {
	//Span          Span           `json:"span"`
	//RaftState     RaftState      `json:"raftState"`
	//State         RangeState     `json:"state"`
	//SourceNodeID  int            `json:"sourceNodeId"`
	//SourceStoreID int            `json:"sourceStoreId"`
	//ErrorMessage  string         `json:"errorMessage"`
	//LeaseHistory  []LeaseHistory `json:"leaseHistory"`
	Problems Problems `json:"problems"`
	//Stats         Stats          `json:"stats"`
	//LatchesLocal  LatchesLocal   `json:"latchesLocal"`
	//LatchesGlobal LatchesGlobal  `json:"latchesGlobal"`
	//LeaseStatus   LeaseStatus    `json:"leaseStatus"`
	//Quiescent     bool           `json:"quiescent"`
	//Ticking       bool           `json:"ticking"`
}
